(() => {
	const themeSelect = document.getElementById('theme-select');
	const storedTheme = localStorage.getItem('themeVariant');
	if (themeSelect && storedTheme) themeSelect.value = storedTheme;
	themeSelect.addEventListener('change', () => {
		const newTheme = themeSelect.value;
		document.documentElement.classList.forEach((c) => {
			if (c.startsWith('theme-'))
				document.documentElement.classList.remove(c);
		});
		if (newTheme) {
			document.documentElement.classList.add(`theme-${newTheme}`);
			localStorage.setItem('themeVariant', newTheme);
		} else {
			localStorage.removeItem('themeVariant');
		}
	});
})();
