@if(have_posts())
  <div class="space-y-8">
    @while(have_posts()) @php(the_post())
      <div class="flex flex-col md:flex-row bg-white shadow rounded-lg overflow-hidden">
        @if(has_post_thumbnail())
          <a href="{{ get_permalink() }}" class="md:w-1/3">
            {!! get_the_post_thumbnail(get_the_ID(), 'medium', ['class' => 'w-full h-48 object-cover md:h-full']) !!}
          </a>
        @endif

        <div class="p-6 flex flex-col justify-between md:w-2/3">
          <div>
            <h2 class="text-2xl font-bold mb-2">
              <a href="{{ get_permalink() }}" class="hover:text-blue-600">{{ get_the_title() }}</a>
            </h2>
            <p class="text-gray-600">{{ get_the_excerpt() }}</p>
          </div>
          <a href="{{ get_permalink() }}" class="mt-4 text-blue-600 font-medium hover:underline self-start">
            Read more →
          </a>
        </div>
      </div>
    @endwhile
  </div>

  <div class="mt-10">
    {!! get_the_posts_navigation() !!}
  </div>
@else
  <p>No posts found.</p>
@endif
