import.meta.glob(['../images/**', '../fonts/**']);

// Swiper JS
import Swiper from 'swiper';
import { EffectCoverflow, Pagination } from 'swiper/modules';
import 'swiper/css';
import 'swiper/css/effect-coverflow';
import 'swiper/css/pagination';

jQuery(document).ready(function ($) {
  $(
    '.navbar-menu .menu-item-has-children > a,.mobile-menu .menu-item-has-children > a'
  ).append('<i class="toggle-icon fas fa-chevron-down"></i>'); // add down icon

  // Hide all submenus initially
  $('.navbar-menu .sub-menu,.mobile-menu .sub-menu').hide();

  // Click handler for parent menu items
  $(
    '.navbar-menu .menu-item-has-children > a,.mobile-menu .menu-item-has-children > a'
  ).click(function (e) {
    e.preventDefault();
    var $parent = $(this).parent();

    // Close other open menus
    $(
      '.navbar-menu .menu-item-has-children,.mobile-menu .menu-item-has-children'
    )
      .not($parent)
      .find('.sub-menu')
      .slideUp();

    $(
      '.navbar-menu .menu-item-has-children,.mobile-menu .menu-item-has-children'
    )
      .not($parent)
      .find('.toggle-icon')
      .removeClass('fa-chevron-up')
      .addClass('fa-chevron-down');

    // Toggle current submenu
    $parent.find('.sub-menu').slideToggle();

    // Toggle icon
    var $icon = $(this).find('.toggle-icon');
    $icon.toggleClass('fa-chevron-down fa-chevron-up');
  });

  /// End sub menu dropdown code

  // Language Shhutter Script
  // Open shutter
  $('#lang-toggle').click(function () {
    $('#lang-shutter')
      .removeClass('translate-x-full')
      .addClass('translate-x-0');
    $('#lang-toggle').addClass('translate-x-[-208px]'); // same as shutter width (52 * 4 = 208px)
  });

  // Close shutter
  $('#lang-close').click(function () {
    $('#lang-shutter')
      .removeClass('translate-x-0')
      .addClass('translate-x-full');
    $('#lang-toggle').removeClass('translate-x-[-208px]');
  });

  // End language shutter script

  // Menu sticky on scroll ///
  var $menu = $('#site-header-navbar');
  var offset = $menu.offset().top;
  $(window).on('scroll', function () {
    if ($(window).scrollTop() > offset) {
      if (!$menu.hasClass('header-sticky')) {
        $menu.addClass('header-sticky');
      }
    } else {
      $menu.removeClass('header-sticky');
    }
  });

  // Open menu
  $('#mobileToggle').on('click', function () {
    $('#mobileMenuOverlay').fadeIn(300);
    $('#mobileMenu').css('transform', 'translateX(100%)');
  });
  $('#mobileClose, #mobileMenuOverlay').on('click', function () {
    $('#mobileMenu').css('transform', 'translateX(-100%)');
    $('#mobileMenuOverlay').fadeOut(300);
  });

  // Tabs JS
  // Hide all tab content first
  $('.tab-content').hide();

  // Show only login form initially
  $('#login-form').show();

  // Set active class on first tab button
  $('.tab-button').removeClass('bg-white shadow-md text-black');
  $('.tab-button[data-target="login-form"]').addClass(
    'bg-white shadow-md text-black'
  );

  // Tab click handler
  $('.tab-button').click(function () {
    $('.tab-button').removeClass('bg-white shadow-md text-black');
    $(this).addClass('bg-white shadow-md text-black');

    var target = $(this).data('target');
    $('.tab-content').fadeOut(200, function () {
      $('#' + target).fadeIn(200);
    });
  });

  // Swiper Slider Coverflow
  const swiper = new Swiper('.coverflow', {
    modules: [EffectCoverflow, Pagination],
    effect: 'coverflow',
    grabCursor: true,
    centeredSlides: true,
    slidesPerView: 'auto',
    coverflowEffect: {
      rotate: 50,
      stretch: 0,
      depth: 100,
      modifier: 1,
      slideShadows: true,
    },
    pagination: {
      el: '.swiper-pagination',
    },
  });
});
// Close on outside click/tap
jQuery(document).on('click touchstart', function (e) {
  // if the click is inside menu, do nothing
  if (jQuery(e.target).closest('.navbar-menu, .mobile-menu').length) {
    return;
  }
  jQuery('.sub-menu').slideUp();
  jQuery('.menu-item-has-children')
    .removeClass('is-open')
    .find('.toggle-icon')
    .removeClass('fa-chevron-up')
    .addClass('fa-chevron-down')
    .end()
    .find('> a')
    .attr('aria-expanded', 'false');
});
