@props([
  'title' => null,
  'image' => null,
  'link' => null,
  'excerpt' => null,
  'class' => '',
])

<div {{ $attributes->merge(['class' => "rounded-md shadow-sm overflow-hidden bg-black $class"]) }}>
  @if($image)
    <img src="{{ $image }}" alt="{{ $title }}" class="w-full h-48 object-cover">
  @endif

  <div class="p-6">
    @if($title)
      <h3 class="text-xl font-bold mb-3">{{ $title }}</h3>
    @endif

      @if($excerpt)
      <p class="text-gray-600 mb-4">
        {{ $excerpt }}
      </p>
    @endif

    @if($link)
      <a href="{{ $link }}" class="inline-block mt-4 text-blue-600 font-medium hover:underline">
        Read more →
      </a>
    @endif
  </div>
</div>
