<?php

namespace App\View\Composers;

use Roots\Acorn\View\Composer;

class Pagination extends Composer
{
    protected static $views = [
        'partials.pagination',
        'partials.content-archive',   // optional
        'index',                      // optional
    ];

    public function with()
    {
        global $wp_query;

        $links = paginate_links([
            'total'     => $wp_query->max_num_pages ?: 1,
            'current'   => max(1, get_query_var('paged')),
            'mid_size'  => 2,
            'prev_text' => __('« Prev'),
            'next_text' => __('Next »'),
            'type'      => 'array',
        ]);

        return [
            'pagination_links' => $links ?: [], // <-- prevent null
        ];
    }
}
