import.meta.glob(['../images/**', '../fonts/**']);

// Swiper JS
import Swiper from 'swiper';
import { Navigation, Pagination, Autoplay } from 'swiper/modules';
import 'swiper/css';
import 'swiper/css/navigation';
import 'swiper/css/pagination';
import 'swiper/css/autoplay';
import '../tailwind-basecoat/basecoat/basecoat-modeSwitcher';

jQuery(document).ready(function ($) {
  $(
    '.navbar-menu .menu-item-has-children > a,.mobile-menu .menu-item-has-children > a',
  ).append('<i class="toggle-icon fas fa-chevron-down"></i>'); // add down icon

  // Hide all submenus initially
  $('.navbar-menu .sub-menu,.mobile-menu .sub-menu').hide();

  // Click handler for parent menu items
  $(
    '.navbar-menu .menu-item-has-children > a,.mobile-menu .menu-item-has-children > a',
  ).click(function (e) {
    e.preventDefault();
    var $parent = $(this).parent();

    // Close other open menus
    $(
      '.navbar-menu .menu-item-has-children,.mobile-menu .menu-item-has-children',
    )
      .not($parent)
      .find('.sub-menu')
      .slideUp();

    $(
      '.navbar-menu .menu-item-has-children,.mobile-menu .menu-item-has-children',
    )
      .not($parent)
      .find('.toggle-icon')
      .removeClass('fa-chevron-up')
      .addClass('fa-chevron-down');

    // Toggle current submenu
    $parent.find('.sub-menu').slideToggle();

    // Toggle icon
    var $icon = $(this).find('.toggle-icon');
    $icon.toggleClass('fa-chevron-down fa-chevron-up');
  });

  /// End sub menu dropdown code

  // Menu sticky on scroll ///
  var $menu = $('#site-header-navbar');
  var offset = $menu.offset().top;
  $(window).on('scroll', function () {
    if ($(window).scrollTop() > offset) {
      if (!$menu.hasClass('header-sticky')) {
        $menu.addClass('header-sticky');
      }
    } else {
      $menu.removeClass('header-sticky');
    }
  });

  // Open menu
  $('#mobileToggle').on('click', function () {
    $('#mobileMenuOverlay').fadeIn(300);
    $('#mobileMenu').css('transform', 'translateX(100%)');
  });
  $('#mobileClose, #mobileMenuOverlay').on('click', function () {
    $('#mobileMenu').css('transform', 'translateX(-100%)');
    $('#mobileMenuOverlay').fadeOut(300);
  });

  // Tabs JS
  // Hide all tab content first
  $('.tab-content').hide();

  // Set active class on first tab button
  $('.tab-button').removeClass('bg-white shadow-md text-black');
  $('.tab-button[data-target="login-form"]').addClass(
    'bg-white shadow-md text-black',
  );

  // Tab click handler
  $('.tab-button').click(function () {
    $('.tab-button').removeClass('bg-white shadow-md text-black');
    $(this).addClass('bg-white shadow-md text-black');

    var target = $(this).data('target');
    $('.tab-content').fadeOut(200, function () {
      $('#' + target).fadeIn(200);
    });
  });

  // Swiper Carousel Slider
});
// Close on outside click/tap
jQuery(document).on('click touchstart', function (e) {
  // if the click is inside menu, do nothing
  if (jQuery(e.target).closest('.navbar-menu, .mobile-menu').length) {
    return;
  }
  jQuery('.sub-menu').slideUp();
  jQuery('.menu-item-has-children')
    .removeClass('is-open')
    .find('.toggle-icon')
    .removeClass('fa-chevron-up')
    .addClass('fa-chevron-down')
    .end()
    .find('> a')
    .attr('aria-expanded', 'false');
});

document.addEventListener('DOMContentLoaded', () => {
  document.querySelectorAll('.carousel-swiper').forEach((slider) => {
    new Swiper(slider, {
      modules: [Navigation, Pagination, Autoplay],
      direction: slider.dataset.direction,
      slidesPerView: parseInt(slider.dataset.slides),
      spaceBetween: parseInt(slider.dataset.space),
      loop: slider.dataset.loop === 'true',

      autoplay:
        slider.dataset.autoplay === 'true'
          ? {
              delay: parseInt(slider.dataset.autoplaySpeed),
              disableOnInteraction: false,
            }
          : false,

      navigation:
        slider.dataset.navigation === 'true'
          ? {
              nextEl: slider.querySelector('.swiper-button-next'),
              prevEl: slider.querySelector('.swiper-button-prev'),
            }
          : false,

      pagination:
        slider.dataset.pagination === 'true'
          ? {
              el: slider.querySelector('.swiper-pagination'),
              clickable: true,
            }
          : false,

      breakpoints: {
        0: { slidesPerView: 1 },
        640: { slidesPerView: 2 },
        1024: { slidesPerView: parseInt(slider.dataset.slides) },
      },
    });
  });
});
