@if(have_posts())
  @php(the_post())
  {{-- First post as featured --}}
  <div class="mb-12 bg-white shadow-lg rounded-lg overflow-hidden">
    @if(has_post_thumbnail())
      <a href="{{ get_permalink() }}">
        {!! get_the_post_thumbnail(get_the_ID(), 'large', ['class' => 'w-full h-72 object-cover']) !!}
      </a>
    @endif
    <div class="p-8">
      <h2 class="text-3xl font-bold mb-4">
        <a href="{{ get_permalink() }}" class="hover:text-blue-600">{{ get_the_title() }}</a>
      </h2>
      <p class="text-gray-700 mb-6">{{ get_the_excerpt() }}</p>
      <a href="{{ get_permalink() }}" class="text-blue-600 font-medium hover:underline">
        Continue reading →
      </a>
    </div>
  </div>

  {{-- Remaining posts in grid --}}
  @if(have_posts())
    <div class="grid gap-8 sm:grid-cols-2 lg:grid-cols-3">
      @while(have_posts()) @php(the_post())
        <x-card
          :title="get_the_title()"
          :link="get_permalink()"
          :image="get_the_post_thumbnail_url(get_the_ID(), 'medium')"
          :excerpt="get_the_excerpt()"
        />
      @endwhile
    </div>
  @endif

  <div class="mt-10">
    {!! get_the_posts_navigation() !!}
  </div>
@else
  <p>No posts found.</p>
@endif
