{{-- Button Variations Configuration Array --}}
@php
$buttonVariations = [
    'primary' => [
        'light' => 'bg-cyan-600 hover:bg-cyan-700 focus:ring-cyan-500 text-white',
        'dark' => 'dark:bg-cyan-500 dark:hover:bg-cyan-600 dark:focus:ring-cyan-400 dark:text-gray-900',
    ],
    'secondary' => [
        'light' => 'bg-slate-100 hover:bg-slate-200 focus:ring-slate-500 text-slate-900 border border-slate-300',
        'dark' => 'dark:bg-slate-900/30 dark:hover:bg-slate-800/40 dark:focus:ring-slate-400 dark:text-slate-100 dark:border-slate-700',
    ],
    'accent' => [
        'light' => 'bg-transparent hover:bg-orange-50 focus:ring-orange-500 text-orange-700 border border-orange-500',
        'dark' => 'dark:bg-transparent dark:hover:bg-orange-900/20 dark:focus:ring-orange-400 dark:text-orange-400 dark:border-orange-500',
    ],
];

// Get the variation from props
$variation = $variation ?? 'primary'; // Default to primary if not provided
$selectedVariation = $buttonVariations[$variation] ?? $buttonVariations['primary'];

$buttonClasses = trim(
    'px-4 py-2 rounded-lg font-medium text-center transition-colors duration-200 focus:outline-none focus:ring-2 focus:ring-offset-2 dark:focus:ring-offset-gray-900 ' .
    $selectedVariation['light'] . ' ' .
    $selectedVariation['dark']
);
@endphp

{{-- Button Component --}}
<a {{ $attributes->merge(['class' => $buttonClasses]) }}>
    {{ $slot }}
</a>

{{-- 
USAGE EXAMPLES:

1. Primary button (cyan colors):
<x-button variation="primary">Primary Button</x-button>

2. Secondary button (slate colors):
<x-button variation="secondary">Secondary Button</x-button>

3. Accent button (orange colors):
<x-button variation="accent">Accent Button</x-button>

4. Default button (no variation specified, defaults to primary):
<x-button>Default Button</x-button>

5. With additional attributes:
<x-button variation="primary" type="submit" class="w-full">
    Submit Form
</x-button>

6. With click handler:
<x-button variation="accent" onclick="alert('Clicked!')">
    Click Me
</x-button>

7. Using dynamic variation from controller:
<x-button :variation="$buttonVariation">
    {{ $buttonText }}
</x-button>

8. Disabled state:
<x-button variation="secondary" disabled>
    Disabled Button
</x-button>
--}}