{{--
  Post Card Component (Blade Component)
  File: resources/views/components/cards/card-cpt.blade.php

  Usage:
  <x-cards.card-cpt post-type="post" posts-per-page="6" columns="3" />
  <x-cards.card-cpt post-type="portfolio" posts-per-page="9" columns="3" show-excerpt="true" />
--}}

@props([
    'postType' => 'post',
    'postsPerPage' => 6,
    'columns' => 3,
    'showExcerpt' => true,
    'excerptLength' => 20
])

@php
  $args = [
    'post_type' => $postType,
    'posts_per_page' => $postsPerPage,
    'post_status' => 'publish',
  ];
  
  $query = new WP_Query($args);
  
  $gridClasses = match($columns) {
    1 => 'grid-cols-1',
    2 => 'grid-cols-1 md:grid-cols-2',
    3 => 'grid-cols-1 md:grid-cols-2 lg:grid-cols-3',
    4 => 'grid-cols-1 md:grid-cols-2 lg:grid-cols-4',
    default => 'grid-cols-1 md:grid-cols-2 lg:grid-cols-3'
  };
@endphp

@if($query->have_posts())
  <div class="py-8">
    <div class="grid {{ $gridClasses }} gap-6">
      @while($query->have_posts())
        @php $query->the_post(); @endphp
        
        <article class="bg-white rounded-sm shadow-md overflow-hidden hover:shadow-xl transition-shadow duration-300 flex flex-col group">
          @if(has_post_thumbnail())
            <div class="relative aspect-video overflow-hidden bg-gray-200">
              <a href="{{ get_permalink() }}" aria-label="{{ get_the_title() }}" class="block h-full">
                {!! get_the_post_thumbnail(get_the_ID(), 'medium_large', [
                  'class' => 'w-full h-full object-cover transform group-hover:scale-105 transition-transform duration-300'
                ]) !!}
              </a>
            </div>
          @endif
          
          <div class="p-6 flex flex-col flex-grow">
            <h3 class="text-xl font-semibold mb-3 line-clamp-2">
              <a href="{{ get_permalink() }}" class="text-gray-900 hover:text-blue-600 transition-colors duration-200">
                {{ get_the_title() }}
              </a>
            </h3>
            
            @if($showExcerpt)
              <div class="text-gray-600 mb-4 flex-grow line-clamp-3">
                {{ wp_trim_words(get_the_excerpt(), $excerptLength, '...') }}
              </div>
            @endif
            
            <div class="flex items-center justify-between pt-4 border-t border-gray-100">
              <time datetime="{{ get_the_date('c') }}" class="text-sm text-gray-500">
                {{ get_the_date() }}
              </time>
              
              <a href="{{ get_permalink() }}" 
                 class="inline-flex items-center text-blue-600 hover:text-blue-700 font-medium text-sm group/link">
                Read More
                <svg class="w-4 h-4 ml-1 transform group-hover/link:translate-x-1 transition-transform duration-200" 
                     fill="none" 
                     stroke="currentColor" 
                     viewBox="0 0 24 24">
                  <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"/>
                </svg>
                <span class="sr-only">about {{ get_the_title() }}</span>
              </a>
            </div>
          </div>
        </article>
      @endwhile
    </div>
  </div>
  
  @php wp_reset_postdata(); @endphp
  
@else
  <div class="py-12 text-center">
    <p class="text-gray-500 text-lg">No {{ $postType }} posts found.</p>
  </div>
@endif