@props([
    'items' => [],
    'box_title' => null,
    'box_content' => null,
    'view' => 'modern',     // modern, classic, simple
    'zoom' => false,
    'columns' => 3
])

@php
use Illuminate\Support\Arr;

// Desktop columns
$columnClass = match ((int) $columns) {
    2 => 'lg:w-[calc(50%-1.5rem)]',
    3 => 'lg:w-[calc(33.333%-1.5rem)]',
    4 => 'lg:w-[calc(25%-1.5rem)]',
    5 => 'lg:w-[calc(20%-1.5rem)]',
    6 => 'lg:w-[calc(16.666%-1.5rem)]',
    default => 'lg:w-[calc(33.333%-1.5rem)]',
};
// Base card classes (common to all views)
$baseCardClasses = 'flex-1 w-full sm:w-[calc(50%-1.5rem)] ' . $columnClass;

// View-specific configurations
$viewConfig = match($view) {
    'classic' => [
        'wrapper' => 'flex flex-wrap justify-center gap-6',
        'card' => Arr::toCssClasses([
            'bg-white dark:bg-neutral-800 shadow-md',
            'rounded-lg overflow-hidden flex flex-col',
            $zoom ? 'hover:shadow-2xl transition-shadow duration-300' : 'transition',
            $baseCardClasses
        ]),
        'image' => 'w-full h-48 object-cover',
        'content' => 'p-4',
        'title' => 'text-2xl font-bold mb-3 text-gray-900 dark:text-white',
        'text' => 'text-gray-700 dark:text-gray-300 leading-relaxed mb-4',
        'link' => 'inline-block mt-auto text-blue-600 dark:text-blue-400 font-semibold hover:underline'
    ],
    'simple' => [
        'wrapper' => 'flex flex-wrap justify-center gap-4',
        'card' => Arr::toCssClasses([
            'bg-transparent flex flex-col items-center text-center',
            $zoom ? 'hover:opacity-80 transition-opacity duration-300' : 'transition',
            $baseCardClasses
        ]),
        'image' => 'w-full h-40 object-cover rounded mb-3',
        'content' => 'px-2',
        'title' => 'text-lg font-semibold mb-2 text-gray-900 dark:text-white',
        'text' => 'text-sm text-gray-600 dark:text-gray-400 mb-3',
        'link' => 'text-sm text-gray-800 dark:text-gray-200 underline hover:no-underline'
    ],
    default => [ // modern
        'wrapper' => 'flex flex-wrap justify-center gap-4',
        'card' => Arr::toCssClasses([
            'bg-white dark:bg-neutral-900 border border-black/10 dark:border-white/10',
            'rounded-sm flex flex-col overflow-hidden group',
            $zoom ? 'hover:scale-105 hover:shadow-xl transition-all duration-300' : 'transition',
            $baseCardClasses
        ]),
        'image' => 'w-full h-52 object-cover group-hover:opacity-90 transition-opacity',
        'content' => 'p-4 flex-1 flex flex-col',
        'title' => 'text-xl font-semibold mb-2 text-gray-900 dark:text-white',
        'text' => 'text-gray-600 dark:text-gray-300 mb-4 flex-1',
        'link' => 'inline-flex items-center text-blue-600 dark:text-blue-400 font-medium hover:gap-2 transition-all'
    ]
};
@endphp

<div {{ $attributes->class('py-8') }}>
    
    {{-- Section Intro --}}
    @if($box_title || $box_content)
        <div class="section-group-intro mb-12">
            @if($box_title)
                <h2 class="text-3xl font-bold text-center mb-3 text-gray-900 dark:text-white">
                    {{ $box_title }}
                </h2>
            @endif
            @if($box_content)
                <div class="text-center text-gray-600 dark:text-gray-300 max-w-3xl mx-auto">
                    {{ $box_content }}
                </div>
            @endif
        </div>
    @endif

    {{-- Cards Grid --}}
    <div class="{{ $viewConfig['wrapper'] }}">
        @foreach($items as $item)
            <div class="{{ $viewConfig['card'] }}">
                
                {{-- Image --}}
                @if(!empty($item['box_image']))
                    <div class="overflow-hidden">
                        <img 
                            src="{{ $item['box_image'] }}" 
                            alt="{{ $item['box_title'] ?? 'Card image' }}" 
                            class="{{ $viewConfig['image'] }}"
                            loading="lazy"
                        >
                    </div>
                @endif

                {{-- Content --}}
                <div class="{{ $viewConfig['content'] }}">
                    @if(!empty($item['box_title']))
                        <h3 class="{{ $viewConfig['title'] }}">
                            {{ $item['box_title'] }}
                        </h3>
                    @endif

                    @if(!empty($item['box_content']))
                        <div class="{{ $viewConfig['text'] }}">
                            {{ $box_content }}
                        </div>
                    @endif
 
                    <x-buttons.buttons href=""  variation="accent">Sec Button</x-buttons>
                </div>
            </div>
        @endforeach
    </div>
</div>

