@props([
  'direction' => 'horizontal', // horizontal | vertical
  'slidesPerView' => 3,
  'spaceBetween' => 20,
  'autoplay' => true,
  'autoplaySpeed' => 3500,
  'pagination' => true,
  'navigation' => true,
  'loop' => true,
])
<div
  class="swiper carousel-swiper" 
  data-direction="{{ $direction }}"
  data-slides="{{ $slidesPerView }}"
  data-space="{{ $spaceBetween }}"
  data-autoplay="{{ $autoplay ? 'true' : 'false' }}"
  data-autoplay-speed="{{ $autoplaySpeed }}"
  data-pagination="{{ $pagination ? 'true' : 'false' }}"
  data-navigation="{{ $navigation ? 'true' : 'false' }}"
  data-loop="{{ $loop ? 'true' : 'false' }}">
  <div class="swiper-wrapper">
      {{ $slot }}
  </div>

  @if($pagination)
      <div class="swiper-pagination"></div>
  @endif

  @if($navigation)
      <div class="swiper-button-prev"></div>
      <div class="swiper-button-next"></div>
  @endif
</div>


