{{-- Hero Section Title overlay on image --}}
@if (!is_front_page())
    @php
        // Determine hero image
        if (has_post_thumbnail() && !is_home() && !is_singular('post')) {
            $hero_image = get_the_post_thumbnail_url(get_the_ID(), 'full');
        } elseif (is_home()) {
            $hero_image = get_field('global_site_top_banner', 'option');
        } elseif (is_singular('post')) {
            $hero_image = get_field('global_site_top_banner', 'option');
        } elseif (get_field('global_site_top_banner', 'option')) {
            $hero_image = get_field('global_site_top_banner', 'option');
        } else {
            $hero_image = 'https://placehold.co/1920x800/eee/000/png';
        }
    @endphp

    <section
        class="relative w-full h-[80vh] bg-cover bg-center"
        style="background-image: url('{{ $hero_image }}');"
    >
        <!-- Black Overlay -->
        <div class="absolute inset-0 bg-black opacity-55"></div>

        <!-- Content Wrapper -->
        <div class="relative z-10 flex items-center justify-center h-full text-center px-4">
            <div class="text-white max-w-2xl">
                @if (is_singular('post') || is_home())
                    <p class="text-md text-white uppercase font-bold py-2 m-0">
                        {{ get_bloginfo('name') }}
                    </p>
                    <h1 class="text-3xl md:text-5xl font-bold">Blog</h1>
                @else
                    <p class="text-md text-white uppercase font-bold py-2 m-0">
                        {{ get_bloginfo('name') }}
                    </p>
                    <h1 class="text-3xl md:text-5xl font-bold">
                        {!! get_the_title() !!}
                    </h1>
                @endif
            </div>
        </div>
    </section>
@endif
