{{-- Hero Section Left Image --}}
@if (!is_front_page())
 @php
        // Determine hero image
        if (has_post_thumbnail() && !is_home() && !is_singular('post')) {
            $hero_image = get_the_post_thumbnail_url(get_the_ID(), 'full');
        } elseif (is_home()) {
            $hero_image = get_field('global_site_top_banner', 'option');
        } elseif (is_singular('post')) {
            $hero_image = get_field('global_site_top_banner', 'option');
        } elseif (is_archive()) {
            $hero_image = get_field('global_site_top_banner', 'option');
        } elseif (get_field('global_site_top_banner', 'option')) {
            $hero_image = get_field('global_site_top_banner', 'option');
        } else {
            $hero_image = 'https://placehold.co/1920x800/eee/000/png';
        }
    @endphp
<section class="relative bg-white py-12 md:py-20 overflow-hidden">
  <div class="container mx-auto px-4 flex flex-col md:flex-row items-center gap-12">

    {{-- Left Image (Blob Shape) --}}
    <div class="relative flex-1 flex justify-center">
      <div class="relative w-[320px] md:w-[420px] aspect-square overflow-hidden">
        <div
          class="absolute inset-0 rounded-[60%_40%_60%_40%/50%_50%_50%_50%] bg-[#d8f8c2] -z-10"
        ></div>
        <img
          src="{{ $hero_image ?? asset('images/hero-header-top.jpg') }}"
          alt="{{ get_the_title() }}"
          class="w-full h-full object-cover rounded-[60%_40%_60%_40%/50%_50%_50%_50%]"
        >
      </div>
    </div>

    {{-- Right Content --}}
    <div class="flex-1 text-center md:text-left">
      @if (is_singular('post') || is_home())
                    <p class="text-md text-white uppercase font-bold py-2 m-0">
                        {{ get_bloginfo('name') }}
                    </p>
                    <h1 class="text-3xl md:text-5xl font-bold">Blog</h1>
                @else
                    <p class="text-md text-white uppercase font-bold py-2 m-0">
                        {{ get_bloginfo('name') }}
                    </p>
                    <h1 class="text-3xl md:text-5xl font-bold">
                        {!! get_the_title() !!}
                    </h1>
                @endif
                <p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry&#8217;s standard dummy text ever since the 1500s, Lorem Ipsum is simply dummy text of the printing and typesetting industry.</p>
      <a href="#" class="btn-primary" title="Read More"> Read More </a>
    </div>

  </div>
</section>
@endif
