<header id="site-header-navbar" class="header-navbar shadow-md">
  <section id="navbar-container" class="flex items-center justify-center container mx-auto">

    {{-- Logo Area --}}
    <nav id="navbar-area-brand" class="p-2 w-1/3 md:w-2/12 lg:w-3/12">
      
      <a class="inline-block"
        href="{{ home_url('/') }}"
        title="{{ get_bloginfo('name') }}"
        rel="home">
        <img class="max-w-[64px] lg:max-w-[96px] rounded-lg"
          src="{{ $site_logo }}"
          alt="{{ get_bloginfo('name') }}"
          title="{{ get_bloginfo('name') }}" />
      </a>

      <p class="site-title hidden">
        <a href="{{ home_url('/') }}" title="{{ get_bloginfo('name') }}" rel="home">
          {{ get_bloginfo('name') }}
        </a>
      </p>
    </nav>

    {{-- Social Icons --}}
    <nav id="navbar-area-social" class="relative flex justify-center md:justify-end md:order-3 p-2 w-1/3 md:w-3/12">
      <ul class="flex gap-4 md:gap-2 lg:gap-4">
        @while(have_rows('social_media_list', 'option'))
          @php the_row() @endphp
          @php
            $social_title = get_sub_field('social_title');
            $social_link  = get_sub_field('social_link');
            $social_class = get_sub_field('social_class');
          @endphp
          <li>
            <a class="text-[#fff] hover:text-[#1e1e1e] transition ease-in-out duration-300 text-3xl"
              href="{{ $social_link }}" title="{{ $social_title }}" target="_blank">
              <i class="{{ $social_class }}"></i>
            </a>
          </li>
        @endwhile
      </ul>
    </nav>

    {{-- Navigation --}}
    <nav id="navbar-area-navigation" class="flex justify-end md:justify-center p-2 w-1/3 md:w-6/12">
      {{-- Desktop Menu --}}
      @php
        wp_nav_menu([
          'theme_location' => 'primary_navigation',
          'container'      => false,
          'menu_class'     => 'hidden md:flex gap-2 lg:gap-4 items-center navbar-menu'
        ]);
      @endphp

      {{-- Mobile Toggle Button --}}
      <button class="block md:hidden text-[#fff] hover:text-[#000] py-1 px-2 navbar-burger text-4xl order-2 md:order-3 cursor-pointer" id="mobileToggle">
        ☰
      </button>
    </nav>
  </section>
</header>

{{-- Mobile Fullscreen Menu --}}
<div id="mobileMenuOverlay" class="fixed h-full w-full top-0 inset-0 bg-black bg-opacity-85 hidden z-90"></div>
<div id="mobileMenu"
  class="fixed top-12 left-0 w-full h-full z-90 px-6 py-2 transform -translate-x-full transition-transform duration-300 ease-in-out md:hidden">
  <div class="flex justify-between items-center">
    {{-- Close Button --}}
    <button id="mobileClose" class="text-4xl absolute top-5 right-6 text-[#fff] px-[10px] py-[5px] cursor-pointer">
      ✕
    </button>

    {{-- Mobile Logo --}}
    <a class="inline-block mx-auto"
      href="{{ home_url('/') }}"
      title="{{ get_bloginfo('name') }}"
      rel="home">
      <img class="mb-4 max-w-[110px] rounded-lg"
        src="{{ $site_logo }}"
        alt="{{ get_bloginfo('name') }}"
        title="{{ get_bloginfo('name') }}" />
    </a>
  </div>

  {{-- Mobile Menu --}}
  @php
    wp_nav_menu([
      'theme_location' => 'primary_navigation',
      'container'      => false,
      'menu_class'     => 'flex flex-col justtify-center gap-6 text-lg mt-8 mobile-menu'
    ]);
  @endphp
</div>
