{{-- 
  Section Wrapper Component
  File: resources/views/components/sections/section-wrapper.blade.php
  Usage:
  <x-sections.section-wrapper container="true" background="primary-bg" spacing="default">
    Your content here
  </x-sections.section-wrapper>
--}}

@php
  // Parse container boolean
  $containerEnabled = filter_var($container ?? true, FILTER_VALIDATE_BOOLEAN);
  
  // Background classes with light/dark mode support
  $bgClasses = [
    'primary-bg' => 'bg-white dark:bg-gray-900 text-gray-900 dark:text-gray-100',
    'secondary-bg' => 'bg-slate-600 dark:bg-gray-800 text-white dark:text-white',
    'accent-bg' => 'bg-blue-50 dark:bg-blue-900/20 text-gray-900 dark:text-gray-100'
  ];
  
  // Spacing classes
  $spacingClasses = [
    'default' => 'py-16 md:py-32',
    'high' => 'py-24 md:py-40',
    'short' => 'py-8 md:py-16',
    'none' => ''
  ];
  
  // Build wrapper classes
  $wrapperClasses = collect([
    $spacingClasses[$spacing ?? 'default'] ?? $spacingClasses['default'],
    isset($background) ? ($bgClasses[$background] ?? '') : '',
    $attributes->get('class')
  ])->filter()->implode(' ');
  
  //Container classes
  $containerClasses = 'container mx-auto px-4 lg:px-0 space-y-24';
@endphp

<section {{ $attributes->merge(['class' => $wrapperClasses]) }}>
  @if($containerEnabled)
    <div class="{{ $containerClasses }}">
      {{ $slot }}
    </div>
  @else
    {{ $slot }}
  @endif
</section>