<?php

namespace Roots\Acorn\View\Composers;

use Illuminate\View\View;
use Roots\Acorn\Application;

class Debugger
{
    /**
     * Create a new Debugger instance.
     */
    public function __construct(Application $app)
    {
        $this->debugLevel = $app['config']['view.debug'];
    }

    /**
     * Compose the view before rendering.
     *
     * @param  View  $view
     * @return void
     */
    public function compose($view)
    {
        $name = $view->getName();

        if ($this->debugLevel === 'view') {
            dump($name);

            return;
        }

        $data = array_map(function ($value) {
            if (is_object($value)) {
                return get_class($value);
            }

            return $value;
        }, $view->getData());

        if ($this->debugLevel === 'data') {
            dump($data);

            return;
        }

        dump(['view' => $name, 'data' => $data]);
    }
}
