<?php
/**
 * @package _liquidbase
 */
?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<?php
    if(is_Front_page()) :
        $latest_cpt = get_posts("post_type=landing_pages&numberposts=1");
        $lid = $latest_cpt[0]->ID;
    else :
        global $post;
        $lid = $post->ID;
    endif;
?>
<head>
    <meta charset="<?php bloginfo( 'charset' ); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="description" content="">
    <link rel="manifest" href="site.webmanifest">
    <link rel="apple-touch-icon-precomposed" sizes="144x144" href='<?php the_field("apple_touch_icon_144", $lid); ?>'>
    <link rel="apple-touch-icon-precomposed" sizes="114x114" href='<?php the_field("apple_touch_icon_114", $lid); ?>'>
    <link rel="apple-touch-icon-precomposed" sizes="72x72" href='<?php the_field("apple_touch_icon_72"
    , $lid); ?>'>
    <link rel="apple-touch-icon-precomposed" href='<?php the_field("apple_touch_icon_57", $lid); ?>'>
    <link rel="shortcut icon" type="image/x-icon" href='<?php the_field("favicon_icon", $lid); ?>'>
    <link rel="profile" href="http://gmpg.org/xfn/11">
    <?php wp_head(); ?>

</head>
<?php  while ( have_posts() ) : the_post(); ?>

<body <?php body_class('landing-page'); ?>>

<?php
$google_tools = get_field('google_tools',$lid);
//if($google_tools == 'ganalytics'):
        $ganalytics = get_field('google_analytics',$lid, false, false);
        echo $ganalytics;
//endif;
//if($google_tools == 'gtagmanager'):
        $gtagmanager = get_field('google_tag_manager',$lid, false, false);  
        echo $gtagmanager; 
//endif;
?>

<?php /*============== Testimonial Submit Form Start ==========*/ ?>

<?php include('include/testimonial-submit-form.php'); ?>

<?php /*============== Testimonial Submit Form End ==========*/ ?>


<?php /*============== Header Start ==========*/ ?>
<header class="wsite-header wrapper">
<section class="csite-header">
    <?php include('include/header.php'); ?>
</section>
</header>
<?php /*============== Header End ==========*/ ?>

<section class="site-content"> 
	<?php /*===================== Main Section Section Start =============*/ ?>
    <?php
        //Section Fields
        $banner_showhide = get_field('banner_showhide',$lid);
    
        if($banner_showhide == "banner_hide"):
            $banner_hide = 'hide-section';
        endif;
    ?>  
    <main class="wsite-main wrapper <?php echo $banner_hide; ?>">
    <section class="csite-main">

        <?php include('include/main.php'); ?>
            
    </section>
    </main>
    <?php /*===================== Main Section Section End =============*/ ?>

    <?php /*===================== Sales Point Section Start =============*/ ?>
    <?php
        //Section Fields
        $sales_points_showhide = get_field('sales_points_showhide',$lid);
        if($sales_points_showhide == "salepoints_hide"):
            $salepoints_hide = 'hide-section';
        endif;
    ?>
    <section class="wsite-salespoints wrapper <?php echo $salepoints_hide; ?>">
	<section class="csite-salespoints container">
        <?php include('include/salespoints.php'); ?>
	</section>
    </section>
    <?php /*===================== Sales Point Section End =============*/ ?>

    <?php /*===================== Aside Section/Benefits Start =============*/ ?>
    <?php
        //Section Fields
        $aside_showhide = get_field('aside_showhide',$lid);
        if($aside_showhide == "aside_hide"):
            $aside_hide = 'hide-section';
        endif;
    ?>
    <aside class="wsite-aside wrapper <?php echo $aside_hide; ?>">
    <section class="csite-aside container">
	    <div class="row-aside">
	    	<?php include('include/aside.php'); ?>
	    </div>
	</section>
    </aside>
    <?php /*===================== Aside/Benefits Section End =============*/ ?>

    <?php /*===================== About Section Start =============*/ ?>
    <?php
        //Section Fields
        $about_title = get_field('about_title',$lid);
        $about_bio = get_field('about_bio',$lid);
        $about_contents = get_field('about_contents',$lid);

        $about_showhide = get_field('about_showhide',$lid);
        if($about_showhide == "about_hide"):
            $about_hide = 'hide-section';
        endif;
    ?>
    <section class="wsite-about wrapper <?php echo $about_hide; ?>">
	<section class="csite-about container">
        <div class="row-about">
        	<?php include('include/about.php'); ?>
        </div>
    </section>
    </section>
    <?php /*===================== About Section End =============*/ ?>
    
    <?php /*===================== Testimonial Section Start =============*/ ?>
    <?php
        //Section Fields
        $testimonial_showhide = get_field('testimonial_showhide',$lid);
        if($testimonial_showhide == "testimonial_hide"):
            $testimonial_hide = 'hide-section';
        endif;
    ?>
    <section class="wsite-testimonials wrapper <?php echo $testimonial_hide; ?>">
    <section class="csite-testimonials container">
        <div class="row-testimonials">
        	<?php include('include/testimonials-repeater.php'); ?>
        </div>
    </section>
    </section>
    <?php /*===================== Testimonial Section End =============*/ ?>

    <?php /*===================== Services Section Start =============*/ ?>
    <?php
        $siervices_showhide = get_field('siervices_showhide',$lid);
        if($siervices_showhide == "service_hide"):
            $service_hide = 'hide-section';
        endif;
    ?>
    <section class="wsite-services wrapper <?php echo $service_hide; ?>">
    <section class="csite-services container">
        <div class="row-services">
            <?php include('include/services.php'); ?>
        </div>
    </section>
    </section>
    <?php /*===================== Services Section End =============*/ ?>

    <?php /*===================== Call To Action start =============*/ ?>
    <?php
    	$call_to_action_showhide = get_field('call_to_action_showhide',$lid);
    	 
	    	if($call_to_action_showhide == 'cta_p_e') :
	    		$cta_p_e  = 'show-section';
	    	endif;
	    	if ($call_to_action_showhide == 'cta_email') :
	    		$cta_email  = 'show-section';
	    	endif;
	    	if ($call_to_action_showhide == 'cta_phone') :
	    		$cta_phone  = 'show-section';
	    	endif;
	   
    ?>
    <?php /*======= Call To Action - Phone & Email =====*/ ?>
    <section class="wctoa-email wrapper <?php echo $cta_p_e; ?>">
    <section class="cctoa-email container">
            <?php include('include/cta-phonemail.php'); ?>
    </section>
    </section>

    <?php /*======= Call To Action - Email =====*/ ?>
    <section class="wctoa-email wrapper <?php echo $cta_email; ?>">
    <section class="cctoa-email container">
        <?php include('include/cta-email.php'); ?>
    </section>
    </section>

    <?php /*======= Call To Action - Phone =====*/ ?>
    <section class="wctoa-email wrapper <?php echo $cta_phone; ?>">
    <section class="cctoa-email container">
        <?php include('include/cta-phone.php'); ?>
    </section>
    </section>
    <?php /*===================== Call To Action End =============*/ ?>


    <?php /*===================== Google Map Start =============*/ ?>
    <?php
        $map_showhide = get_field('map_showhide',$lid);
        if($map_showhide == 'hide'):
            $map_hide = 'hide-section';
        endif;
    ?>
    <section class="wgooglemap wrapper <?php echo $map_hide; ?>">
        <div id="google-map" class="google-map"></div>
    </section>
    <?php /*===================== Google Map End =============*/ ?>
</section>

<?php /*===================== Footer Start =============*/ ?>
<footer class="site-footer">
	<?php /*=== Footer Branding ====*/ ?>
    <section class="wrapper wfooter-branding">
    <section class="container cfooter-branding">
        <div class="row">
            <?php include('include/footer-branding.php'); ?>
        </div>
    </section>
    </section>

    <?php /*=== Footer CopyRight ====*/ ?>
    <?php
        $copy_right_showhide = get_field('copy_right_showhide',$lid);
        if($copy_right_showhide == 'copyright_hide'):
            $copy_right_hide = 'hide-section';
        endif;
    ?>
    <section class="wrapper wfooter-credits <?php echo $copy_right_hide; ?>">
    <section class="container cfooter-credits">
        <div class="row">
            <?php include('include/footer-copyright.php'); ?>    
        </div>
    </section>
    </section>
</footer>
<?php /*===================== Footer End =============*/ ?>

<?php	endwhile;  ?>

<?php /*============= Google map configure start =============*/ ?>

<?php include('include/google-map.php'); ?>

<?php /*============= Google map configure end =============*/ ?>   

<?php wp_footer(); ?>

</body>
</html>