<?php

/*
Plugin Name: Lws Landing Pages
Plugin URI: https://liquidstudiogroup.com/
Description: This Landing page plugin created for individual pages to promotional offer and medical treatment by Liquid Group. 
Author: Liquid Studio Group
Version: 1.0
Author URI: https://liquidstudiogroup.com/
*/
/**
 *
 * Register post type

 *
 */
 if (!defined('LANPATH')) {
    define('LANPATH', plugin_dir_path(__FILE__));
}
// ===== CPT: Landing Pages =====//

if ( !post_type_exists('landing_pages') ) {
	function register_show_type() {
		$label_singular = 'Landing Page';
		$label_plural   = 'Landing Pages';
		register_post_type(
			'landing_pages',
			array(
				'label'           => $label_plural,
				'description'     => '',
				'public'          => true,
				'show_ui'         => true,
				'show_in_menu'    => true,
				'capability_type' => 'page',
				'hierarchical'    => false,
				'query_var'       => true,
				'menu_icon'       => 'dashicons-images-alt2',
				'has_archive'     => true,
				'rewrite' => array(
					'slug'       => 'lws-landing-pages',
				),
				'supports' => array(
					'title',
				),
				'labels' => array (
					'name'               => $label_plural,
					'singular_name'      => $label_singular,
					'menu_name'          => $label_plural,
					'add_new'            => 'Add New',
					'add_new_item'       => 'Add New ' . $label_singular,
					'edit'               => 'Edit',
					'edit_item'          => 'Edit ' . $label_singular,
					'new_item'           => 'New ' . $label_singular,
					'view'               => 'View ' . $label_singular,
					'view_item'          => 'View ' . $label_singular,
					'search_items'       => 'Search ' . $label_plural,
					'not_found'          => 'No ' . $label_plural . ' Found',
					'not_found_in_trash' => 'No ' . $label_plural . ' Found in Trash',
					'parent'             => 'Parent ' . $label_singular,
				)
			)
		);
	}
	add_action('init', 'register_show_type');
}
// ===== Category: Landing Pages =====//

function register_lws_landing_cat() {
	$cat_label_singular = 'Category';
	$cat_label_plural   = 'Categories';

    $labels = array(
        'name'              => $cat_label_plural,
        'singular_name'     => $cat_label_singular,
        'search_items'      => __( 'Search Category', 'LSMC ' ),
        'all_items'         => __( 'All Category', 'LSMC ' ),
        'parent_item'       => __( 'Parent Category', 'LSMC ' ),
        'parent_item_colon' => __( 'Parent Category:', 'LSMC ' ),
        'edit_item'         => __( 'Edit Category', 'LSMC ' ),
        'update_item'       => __( 'Update Category', 'LSMC ' ),
        'add_new_item'      => __( 'Add New', 'LSMC ' ),
        'new_item_name'     => __( 'New Category Name', 'LSMC ' ),
        'menu_name'         => $cat_label_plural,
    );

    $args = array(
        'hierarchical'      => true, // Make it hierarchical (like categories)
        'labels'            => $labels,
        'show_ui'           => true,
        'show_admin_column' => true,
        'query_var'         => true,
        'rewrite' => array(	'slug'=> 'lws-landing-category')
    );

    register_taxonomy( 'lws_landing_cat', array( 'landing_pages' ), $args );
}
add_action( 'init', 'register_lws_landing_cat', 0 );

function register_lws_landing_tags() {
    $labels = array(
        'name'                       => _x( 'Landing Tags', 'taxonomy general name', 'LSMC ' ),
        'singular_name'              => _x( 'Landing Tag', 'taxonomy singular name', 'LSMC ' ),
        'search_items'               => __( 'Search  Tags', 'LSMC ' ),
        'popular_items'              => __( 'Popular Tags', 'LSMC ' ),
        'all_items'                  => __( 'All Tags', 'LSMC ' ),
        'parent_item'                => null,
        'parent_item_colon'          => null,
        'edit_item'                  => __( 'Edit Tag', 'LSMC ' ),
        'update_item'                => __( 'Update  Tag', 'LSMC ' ),
        'add_new_item'               => __( 'Add New Tag', 'LSMC ' ),
        'new_item_name'              => __( 'New Tag Name', 'LSMC ' ),
        'separate_items_with_commas' => __( 'Separate tags with commas', 'LSMC ' ),
        'add_or_remove_items'        => __( 'Add or remove tags', 'LSMC ' ),
        'choose_from_most_used'      => __( 'Choose from the most used tags', 'LSMC ' ),
        'not_found'                  => __( 'No tags found.', 'LSMC ' ),
        'menu_name'                  => __( 'Landing Page Tags', 'LSMC ' ),
    );

    $args = array(
        'hierarchical'          => false,
        'labels'                => $labels,
        'show_ui'               => true,
        'show_admin_column'     => true,
        'update_count_callback' => '_update_post_term_count',
        'query_var'             => true,
        'rewrite'               => array( 'slug' => 'lws-landing-tag' ),
    );

    register_taxonomy( 'lws_landing_tags', 'landing_pages', $args );
}
add_action( 'init', 'register_lws_landing_tags', 0 );




// ===== Include As a Front Page =====//

add_filter( 'template_include', 'landi_page_template', 99 );

function landi_page_template( $template ) {
	if ( 'landing_pages' == get_post_type() ) {
		 return mlsp_get_template_hierarchy('single-landing_pages');
	}
	return $template;
}

function mlsp_get_template_hierarchy($template) {
    $template_slug = rtrim($template, '.php');
    $template = $template_slug . '.php';
    $file = LANPATH . '/templates/' . $template;
    
		return apply_filters('mlsp_repl_template_' . $template, $file);
}

// ===== Include Landing Page Style =====//

function lan_load_css_js() {
    ///// Google Fonts ////////////////////////
    wp_register_style(
        'googleFonts', 
        'https://fonts.googleapis.com/css?family=Oswald:300,400,700');
    wp_enqueue_style( 'googleFonts');
    wp_register_style(
        'googleFonts1', 
        'https://fonts.googleapis.com/css?family=Open+Sans+Condensed:300,300i,700');
    wp_enqueue_style( 'googleFonts1');
    $plugin_url = plugin_dir_url(__FILE__);
    wp_enqueue_style('lws_landing_style', $plugin_url . 'assets/style.css',false,'1.0', 'all');
    wp_enqueue_style('lws_landing_custom_style', $plugin_url . 'assets/lws-style-custom.css',false,'1.0', 'all');
}

add_action('wp_enqueue_scripts', 'lan_load_css_js');
// ===== ACF Field Groups Code =====//

require_once(LANPATH . '/templates/landing-acf-fields.php');
// ===== Gravity Form =====//
//define( 'GF_THEME_IMPORT_FILE', LANPATH . 'assets/form/gravityforms-export.json' );