<?php
/**
 * === Liquid Studio Code ========================
 * Rockwall v1.0 functions and definitions.
 * @package LSMC
 * slug: LSMC
 */

///// Admin ////////////////////////
// -- Admin Look --
// require_once('inc/admin/customise-admin-login-logo.php');
// require_once('inc/admin/customise-admin-logo.php');
// require_once('inc/admin/customize-admin-menu-order.php');
require_once('inc/admin/customise-admin-footer-credit.php');
require_once('inc/theme/load-and-register-css-and-js-for-admin.php');
// -- Global --
require_once('inc/admin/include-post-page-ids-in-admin-table.php');
require_once('inc/admin/add-post-thumbnails-into-admin-table.php');
require_once('inc/admin/posts-status-color.php');
// -- Posts --
require_once('inc/admin/filter-admin-table-columns-post.php');
// require_once('inc/admin/admin-posts-to-news.php');
// require_once('inc/admin/admin-news-taxonomies.php');
// -- Pages --
require_once('inc/admin/filter-admin-table-columns-page.php');
require_once('inc/admin/add-excerpts-to-pages.php');
// require_once('inc/admin/add-move-excerpts-to-above-editor.php');
// -- Images --
require_once('inc/admin/disable-image-auto-resizing.php');
require_once('inc/admin/add-multiple-featured-images.php');

///// Theme ////////////////////////
require_once('inc/theme/load-and-register-css-and-js.php');
// require_once('inc/theme/wp_bootstrap_navwalker.php');

///// Custom ////////////////////////
// require_once('inc/custom/create-thumbnail-sizes.php');
// require_once('inc/custom/register-menus.php');
// require_once('inc/custom/pagination-without-plugin.php');
// require_once('inc/custom/breadcrumbs-without-plugin1.php');

///// Custom Post Types ////////////////////////
require_once('inc/cpt/cpt-lsmc-patient-success-story.php');
require_once('inc/cpt/cpt-lsmc-athletespotlight.php');
require_once('inc/cpt/cpt-lsmc-news.php');
require_once('inc/cpt/cpt-lsmc-share-stories.php');

///// ACF: CPT Content (Options) Pages ////////////////////////
// if(function_exists(acf_add_options_page)) {
// 	require_once('inc/acf/acf-content-cpt-treatments.php');
// 	require_once('inc/acf/acf-content-cpt-giftcertificates.php');
// }
// add_action('init', 'acf_add_options_page');*/

/*** Custom Widgets ***/
// require_once('inc/widgets/foowidget/foowidget.php');
// require_once('inc/widgets/latestposts/latestposts.php');
//require_once('inc/widgets/pageinfo/pageinfo.php');
require_once('inc/widgets/recent-post-with-thumb/wp_recent_post_with_thumb.php');


///// _s Underscores ////////////////////////
require_once('inc/underscores/functions.php');

/**
 * === Wordpress/Underscores ========================
 * Rockwall v1.0 functions and definitions.
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 * @package Rockwall_v1.0
 */

if ( ! function_exists( 'rockwallv1_setup' ) ) :
/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which
 * runs before the init hook. The init hook is too late for some features, such
 * as indicating support for post thumbnails.
 */
function rockwallv1_setup() {
	/*
	 * Make theme available for translation.
	 * Translations can be filed in the /languages/ directory.
	 * If you're building a theme based on Rockwall v1.0, use a find and replace
	 * to change 'rockwallv1' to the name of your theme in all the template files.
	 */
	load_theme_textdomain( 'rockwallv1', get_template_directory() . '/inc/languages' );

	// Add default posts and comments RSS feed links to head.
	add_theme_support( 'automatic-feed-links' );

	/*
	 * Let WordPress manage the document title.
	 * By adding theme support, we declare that this theme does not use a
	 * hard-coded <title> tag in the document head, and expect WordPress to
	 * provide it for us.
	 */
	add_theme_support( 'title-tag' );

	/*
	 * Enable support for Post Thumbnails on posts and pages.
	 * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
	 */
	add_theme_support( 'post-thumbnails' );

	// This theme uses wp_nav_menu() in one location.
	register_nav_menus( array(
		'primary' => esc_html__( 'Primary', 'rockwallv1' ),
	) );

	/*
	 * Switch default core markup for search form, comment form, and comments
	 * to output valid HTML5.
	 */
	add_theme_support( 'html5', array(
		'search-form',
		'comment-form',
		'comment-list',
		'gallery',
		'caption',
	) );

	// Set up the WordPress core custom background feature.
	add_theme_support( 'custom-background', apply_filters( 'rockwallv1_custom_background_args', array(
		'default-color' => 'ffffff',
		'default-image' => '',
	) ) );
}
endif;
add_action( 'after_setup_theme', 'rockwallv1_setup' );

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 * Priority 0 to make it available to lower priority callbacks.
 * @global int $content_width
 */
function rockwallv1_content_width() {
	$GLOBALS['content_width'] = apply_filters( 'rockwallv1_content_width', 640 );
}
add_action( 'after_setup_theme', 'rockwallv1_content_width', 0 );

// Replaces all spaces with hyphens.
function clean($string) {
	$string = str_replace(' ', '_', $string); // Replaces all spaces with hyphens.
	return preg_replace('/[^A-Za-z0-9\-]/', '', $string); // Removes special chars.
 }

/**
 * Register widget area.
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function _liquidbase_widgets_init() {
	register_sidebar( array(
		'name'          => esc_html__( 'Sidebar', 'rockwallv1' ),
		'id'            => 'sidebar-1',
		'description'   => esc_html__( 'Add widgets here.', 'rockwallv1' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );
	// Search widget
	register_sidebar( array(
		'name'          => esc_html__( 'Search', '_liquidbase' ),
		'id'            => 'search-widget',
		'description'   => esc_html__( 'Add widgets here.', '_liquidbase' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );
}
add_action( 'widgets_init', '_liquidbase_widgets_init' );

/**
 * Acf Option Page
 */

if( function_exists('acf_add_options_page') ) {
	
	acf_add_options_page();
	
}

/**
 * Remove bracket
 */
function new_excerpt_more( $more ) {
	return ' ';
}
add_filter('excerpt_more', 'new_excerpt_more');

/**
 * remove emoji scripts and style
 */
remove_action( 'wp_head', 'print_emoji_detection_script', 7 );
remove_action( 'wp_print_styles', 'print_emoji_styles' );


/**
 * Remove type attribute from Script and Style
 */
add_filter('style_loader_tag', 'codeless_remove_type_attr', 10, 2);
add_filter('script_loader_tag', 'codeless_remove_type_attr', 10, 2);
function codeless_remove_type_attr($tag, $handle) {
    return preg_replace( "/type=['\"]text\/(javascript|css)['\"]/", '', $tag );
}

add_filter( 'envira_gallery_get_transient_markup', '__return_false' );

function disable_author_page() {
    global $wp_query;

    // If an author page is requested, redirects to the home page
    if ( $wp_query->is_author ) {
        wp_safe_redirect( get_bloginfo( 'url' ), 301 );
        exit;
    }

}
add_action( 'wp', 'disable_author_page' );

/*Gravity Forms Filter to Use WP 'Comment Blacklist' as Validation Parameter*/
add_filter( 'gform_validation', 'custom_validation' );
function custom_validation( $validation_result ) {
    if ( false === get_option( 'disallowed_keys' ) ) {
    // Assume this is WP < 5.5. Option does not exist.
		$blacklisted = get_option('blacklist_keys');
		} else {
	// Assume this is WP >= 5.5
		$blacklisted = get_option('disallowed_keys');
	}
	//Turn WP Blacklist Words into Array
	$badWords = preg_split("/[\s,]+/", $blacklisted);
	//Function to Check Submitted Field Value Against Blacklist Array. Will be Called in the Fields Loop.
	function contains($field_value, array $badWords){
		foreach($badWords as $i) {
			if (stripos($field_value,$i) !== false)return true;
		}
			return false;
	}

    $form = $validation_result['form'];
        //Loop through Form Fields
        foreach( $form['fields'] as &$field ) {
            //Store Submitted Field Value in a Local Variable
			$field_value = rgpost( "input_{$field['id']}" );
			//Use Function
            if (contains($field_value, $badWords)){
				// set the form validation to false
				$validation_result['is_valid'] = false;
                $field->failed_validation = true;
                $field->validation_message = 'This field contains not allowed words!';
                break;
			}
			else {
				continue;
			}
        }
 
    //Assign modified $form object back to the validation result
    $validation_result['form'] = $form;
    return $validation_result;
}