<?php
// Register Custom Post Type - Athlete Spotlight
register_post_type( 'cpt_athletespotlight',
    array(
    'labels' => array(
        'name'                => _x( 'Spotlights', 'Spotlights', 'text_domain' ),
        'singular_name'       => _x( 'Spotlight Item', 'News Item', 'text_domain' ),
        'menu_name'           => __( 'Athlete Spotlight', 'text_domain' ),
        'name_admin_bar'      => __( 'Spotlights', 'text_domain' ),
        'parent_item_colon'   => __( 'Spotlights:', 'text_domain' ),
        'all_items'           => __( 'All Spotlights', 'text_domain' ),
        'add_new_item'        => __( 'Add New Spotlight', 'text_domain' ),
        'add_new'             => __( 'Add an Spotlight', 'text_domain' ),
        'new_item'            => __( 'New Spotlight', 'text_domain' ),
        'edit_item'           => __( 'Edit Spotlight', 'text_domain' ),
        'update_item'         => __( 'Update Spotlight', 'text_domain' ),
        'view_item'           => __( 'View Spotlight', 'text_domain' ),
        'search_items'        => __( 'Search Spotlights', 'text_domain' ),
        'not_found'           => __( 'No Spotlights found', 'text_domain' ),
        'not_found_in_trash'  => __( 'No Spotlights found in Trash', 'text_domain' ),
    ),

    'label'               => __( 'Spotlights', 'text_domain' ),
    'description'         => __( 'Athlete Spotlights Description', 'text_domain' ),
    'supports'            => array('title','editor','thumbnail','excerpt'),
    // 'taxonomies'          => array( 'category', 'post_tag' ),
    'hierarchical'        => false,
    'public'              => true,
    'show_ui'             => true,
    'show_in_menu'        => true,
    'menu_position'       => 1,
    'menu_icon'           => 'dashicons-pressthis',
    'show_in_admin_bar'   => true,
    'show_in_nav_menus'   => true,
    'can_export'          => true,
    'has_archive'         => true,
    'exclude_from_search' => false,
    'publicly_queryable'  => true,
    'capability_type'     => 'post',
    'rewrite'             => array( 'slug'=>'athlete-spotlights' ),
    )
);
?>
