<?php
/**
 * @package Rockwall_v1.0
 */
?>
<article id="post-<?php the_ID(); ?>" <?php post_class('category_list'); ?>>

	<div class="row clearfix">
		
			<div class="col-sm-4 summary-left">
				<?php if ( has_post_thumbnail()) : ?>
					<figure>
						<a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>">
							<?php the_post_thumbnail( '', array( 'class' => 'img-fluid', 'title' => get_the_title() ) ); ?>
						</a>
					</figure>
				<?php endif; ?>
			</div>
			
			<div class="col-sm-8 summary-right">
				<?php 
					the_title( '<h2 class="article-title"><a href="' . esc_url( get_permalink() ) . '" title="' . get_the_title() . '" rel="bookmark">', '</a></h2>' );
				?>
				<?php if ( 'post' === get_post_type() ) : ?>
				<div class="entry-meta">
					<span class="posted-on">
						<label class="entry-text-posted">Posted on: </label>
						<span class="entry-date"><?php echo get_the_date('F j, Y'); ?></span> 
						<span class="entry-by-text">by</span> 
						<span class="entry-author"><?php echo get_the_author(); ?></span>
					</span> 
							
					
					<span class="posted-in">
            <span class="cat-links">Posted in 
              <?php
                $categories = get_the_category();
                foreach($categories as $category){
                  echo '<a href="'.get_category_link($category->term_id ).'" title="'.$category->cat_name.'">'.$category->cat_name.'</a>';
              }
              ?>
            </span>
					</span> 
					<span class="posted-tags">
						<?php
							echo get_the_tag_list('<span class="tag-links">Tags: ',', ','</span>');
						?>
					</span>
				</div>
				<?php endif; ?>
				<p class="article-text"><?php echo get_the_excerpt(); ?> ...</p>
			</div>
			
		</div>
		
		<div class="row">
			<div class="col-xs-12">
        		<a class="btn btn-cat pull-xs-right" href="<?php the_permalink(); ?>" title="More about <?php the_title(); ?>"> More »</a>
        	</div>
        </div>

</article>
