<?php $paged = ( get_query_var('paged') ) ? get_query_var('paged') : 1; ?>
<?php $args = array(
     	'post_type' => array( 'cpt_patient_story' ),
     	'posts_per_page' => 5,
     	'paged' => $paged
      ); 
	$wp_query = new WP_Query( $args );
	if ( $wp_query->have_posts() ) : 
	  while ( $wp_query->have_posts() ) : $wp_query->the_post(); ?>

		<article id="post-<?php the_ID(); ?>" <?php post_class('category_list'); ?>>

			<div class="row clearfix">
				
					<div class="col-sm-4 summary-left">
						<?php if ( has_post_thumbnail()) : ?>
							<figure>
								<a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>">
									<?php the_post_thumbnail( '', array( 'class' => 'img-fluid' ) ); ?>
								</a>
							</figure>
						<?php endif; ?>
					</div>
					
					<div class="col-sm-8 summary-right">
						<?php 
							the_title( '<h2 class="article-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' );
						?>
						<p class="article-text"><?php echo get_the_excerpt(); ?> ...</p>
					</div>
					
				</div>
				
				<div class="row">
					<div class="col-xs-12">
		        		<a class="btn btn-cat pull-xs-right" href="<?php the_permalink(); ?>"> More »</a>
		        	</div>
		        </div>

		</article>
		
	  	<?php endwhile; ?>
		<div class="pager">
		<?php
		    global $wp_query;
		    $big = 999999999; // need an unlikely integer
		    echo paginate_links( array(
		        'base' => str_replace( $big, '%#%', esc_url( get_pagenum_link( $big ) ) ),
		        'format' => '?paged=%#%',
		        'current' => max( 1, get_query_var('paged') ),
		        'total' => $wp_query->max_num_pages
		    ) );
		    wp_reset_query();
		?>
		</div>
	<?php endif; ?>