<?php
/**
 * @package _liquidbase
 */

/* Widget areas */
function _liquidbase_widgets_init() {

	// Top Bar
	register_sidebar( array(
		'name'          => esc_html__( 'Top Row', '_liquidbase' ),
		'id'            => 'widget-toprow',
		'description'   => esc_html__( 'Add widgets here.', '_liquidbase' ),
		'before_widget' => '<div class="widget-toprow">',
		'after_widget'  => '</div>',
		'before_title'  => '',
		'after_title'   => '',
	) );

	// Main Navigation
	register_sidebar( array(
		'name'          => esc_html__( 'Main Navigation', '_liquidbase' ),
		'id'            => 'widget-main-navigation',
		'description'   => esc_html__( 'Add widgets here.', '_liquidbase' ),
		'before_widget' => '<div class="widget-main-navigation">',
		'after_widget'  => '</div>',
		'before_title'  => '',
		'after_title'   => '',
	) );

	// Sidebar WP Default
	register_sidebar( array(
		'name'          => esc_html__( 'Sidebar', '_liquidbase' ),
		'id'            => 'sidebar-1',
		'description'   => esc_html__( 'Add widgets here.', '_liquidbase' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );

	// Footer Navigation
	register_sidebar( array(
		'name'          => esc_html__( 'Footer Navigation', '_liquidbase' ),
		'id'            => 'widget-footer-navigation',
		'description'   => esc_html__( 'Add widgets here.', '_liquidbase' ),
		'before_widget' => '<div class="widget-footer-navigation">',
		'after_widget'  => '</div>',
		'before_title'  => '',
		'after_title'   => '',
	) );

	// Footer About
	register_sidebar( array(
		'name'          => esc_html__( 'Footer About', '_liquidbase' ),
		'id'            => 'widget-footer-about',
		'description'   => esc_html__( 'Add widgets here.', '_liquidbase' ),
		'before_widget' => '<div class="widget-footer-about">',
		'after_widget'  => '</div>',
		'before_title'  => '<h3>',
		'after_title'   => '</h3>',
	) );

	// Footer Sitemap
	register_sidebar( array(
		'name'          => esc_html__( 'Footer Sitemap', '_liquidbase' ),
		'id'            => 'widget-footer-sitemap',
		'description'   => esc_html__( 'Add widgets here.', '_liquidbase' ),
		'before_widget' => '<div class="widget-footer-sitemap">',
		'after_widget'  => '</div>',
		'before_title'  => '<h3>',
		'after_title'   => '</h3>',
	) );

	// Footer Areas Served
	register_sidebar( array(
		'name'          => esc_html__( 'Footer Areas Served', '_liquidbase' ),
		'id'            => 'widget-footer-areasserved',
		'description'   => esc_html__( 'Add widgets here.', '_liquidbase' ),
		'before_widget' => '<div class="widget-footer-areasserved">',
		'after_widget'  => '</div>',
		'before_title'  => '<h3>',
		'after_title'   => '</h3>',
	) );

	// Footer Industies
	register_sidebar( array(
		'name'          => esc_html__( 'Footer Google', '_liquidbase' ),
		'id'            => 'widget-footer-google',
		'description'   => esc_html__( 'Add widgets here.', '_liquidbase' ),
		'before_widget' => '<div class="widget-footer-industries">',
		'after_widget'  => '</div>',
		'before_title'  => '<h3>',
		'after_title'   => '</h3>',
	) );

	// Footer Recent Posts
	register_sidebar( array(
		'name'          => esc_html__( 'Footer Recent Posts', '_liquidbase' ),
		'id'            => 'widget-footer-recentposts',
		'description'   => esc_html__( 'Add widgets here.', '_liquidbase' ),
		'before_widget' => '<div class="widget-footer-recentposts">',
		'after_widget'  => '</div>',
		'before_title'  => '<h3>',
		'after_title'   => '</h3>',
	) );

	// Footer Contact
	register_sidebar( array(
		'name'          => esc_html__( 'Footer Contact', '_liquidbase' ),
		'id'            => 'widget-footer-contact',
		'description'   => esc_html__( 'Add widgets here.', '_liquidbase' ),
		'before_widget' => '<div class="widget-footer-contact">',
		'after_widget'  => '</div>',
		'before_title'  => '<h3>',
		'after_title'   => '</h3>',
	) );

}
add_action( 'widgets_init', '_liquidbase_widgets_init' );
