<?php
// Register Custom Post Type - LSMC Staff
register_post_type( 'cpt_lsmcstaff',
    array(
    'labels' => array(
        'name'                => _x( 'Staff', 'Staff', 'text_domain' ),
        'singular_name'       => _x( 'Staff', 'Staff', 'text_domain' ),
        'menu_name'           => __( 'LSMC Staff', 'text_domain' ),
        'name_admin_bar'      => __( 'Staff', 'text_domain' ),
        'parent_item_colon'   => __( 'Parent Staff:', 'text_domain' ),
        'all_items'           => __( 'All Staff', 'text_domain' ),
        'add_new_item'        => __( 'Add New Staff', 'text_domain' ),
        'add_new'             => __( 'Add a staff', 'text_domain' ),
        'new_item'            => __( 'New Staff', 'text_domain' ),
        'edit_item'           => __( 'Edit Staff', 'text_domain' ),
        'update_item'         => __( 'Update Staff', 'text_domain' ),
        'view_item'           => __( 'View Staff', 'text_domain' ),
        'search_items'        => __( 'Search in Staff', 'text_domain' ),
        'not_found'           => __( 'No member found', 'text_domain' ),
        'not_found_in_trash'  => __( 'No member found in Trash', 'text_domain' ),
    ),
    'label'               => __( 'LSMC Staff', 'text_domain' ),
    'description'         => __( 'LSMC Staff Description', 'text_domain' ),
    'supports'            => array('title','editor','thumbnail','excerpt'),
    //'taxonomies'          => array( 'category', 'post_tag' ),
    'hierarchical'        => true,
    'public'              => true,
    'show_ui'             => true,
    'show_in_menu'        => true,
    'menu_position'       => 5,
    'menu_icon'           => 'dashicons-buddicons-buddypress-logo',
    'show_in_admin_bar'   => true,
    'show_in_nav_menus'   => true,
    'can_export'          => true,
    'has_archive'         => true,
    'exclude_from_search' => false,
    'publicly_queryable'  => true,
    'capability_type'     => 'page',
    'rewrite'             => array( 'slug'=>'lsmc-staff' ),
    )
);

// Custom Taxonomies: Categories ///////////////////////////////////
function lsmcstaff_categories_taxonomies() {

    // LSMC Staff Categories
    $labels = array(
        'name'              => 'Staff Post',
        'singular_name'     => 'Category',
        'search_items'      => 'Search Categories',
        'all_items'         => 'All Categories',
        'parent_item'       => 'Parent Category',
        'parent_item_colon' => 'Parent Category:',
        'edit_item'         => 'Edit Category',
        'update_item'       => 'Update Category',
        'add_new_item'      => 'Add New Category',
        'new_item_name'     => 'New Category',
        'menu_name'         => 'Categories',
    );

    $args = array(
        'hierarchical'      => true,
        'labels'            => $labels,
        'show_ui'           => true,
        'show_admin_column' => true,
        'query_var'         => true,
        'rewrite'           => array( 'slug' => 'lsmc-staff-categories' ),
    );

    register_taxonomy( 'staff-categories', array( 'cpt_lsmcstaff' ), $args );
}
add_action( 'init', 'lsmcstaff_categories_taxonomies');
?>
