<?php
/*--------------------------------------------------------------
 * Load and Register Css and JS
 *------------------------------------------------------------*/

///// Google Fonts ////////////////////////
function liquidbase_load_fonts() {
     wp_register_style(
         'googleFonts', 
         'https://fonts.googleapis.com/css?family=Oswald:300,400,700');
     wp_enqueue_style( 'googleFonts');

     wp_register_style(
         'googleFonts1', 
         'https://fonts.googleapis.com/css?family=Open+Sans+Condensed:300,300i,700');
     wp_enqueue_style( 'googleFonts1');
     
 }
 add_action('wp_print_styles', 'liquidbase_load_fonts');

///// Enqueue scripts and styles ////////////////////////
function lsmc_scripts() {
    ///// Styles /////
    //wp_enqueue_style( 'bootstrap-css', get_template_directory_uri() . '/lib/bootstrap/4.0.0/css/bootstrap.4.0.0.min.css' );
    wp_enqueue_style( 'lsmc-style', get_stylesheet_uri() );

    ///// Scripts /////
    // -- JQUERY --
    wp_enqueue_script('jquery');
   
	
    wp_enqueue_script( 'lsmc-navigation', get_template_directory_uri() . '/js/underscores/navigation.js', array(), '20151215', true );
	
    wp_enqueue_script( 'lsmc-skip-link-focus-fix', get_template_directory_uri() . '/js/underscores/skip-link-focus-fix.js', array(), '20151215', true );
	
    if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
        wp_enqueue_script( 'comment-reply' );
    }
    
    // -- Bootstrap: JS --
    wp_register_script( 'bootstrap-min-js', get_template_directory_uri() . '/lib/bootstrap/4.6.0/js/bootstrap.min.js', array(), '4.6.0', true );
    wp_enqueue_script( 'bootstrap-min-js' );

    // -- Font Awesome: JS --
    wp_register_script( 'all-min-js', get_template_directory_uri() . '/lib/font-awesome/js/all.min.js', array(), '5.3.0', true );
    wp_enqueue_script( 'all-min-js' );

    // -- Font Awesome: JS --
    wp_register_script( 'v4-shims-js', get_template_directory_uri() . '/lib/font-awesome/js/v4-shims.min.js', array(), '5.3.0', true );
    wp_enqueue_script( 'v4-shims-js' );

    // -- Owl JS --
    wp_register_script( 'owl-min-js', get_template_directory_uri() . '/js/owl.carousel.min.js', array(), '3.6.0', true );
    wp_enqueue_script( 'owl-min-js' );

    // -- Custom: JS --
    wp_register_script( 'custom-js', get_template_directory_uri() . '/js/custom.js', array(), '12.02.16', true );
    wp_enqueue_script( 'custom-js' );

}
add_action( 'wp_enqueue_scripts', 'lsmc_scripts' );
