<?php
/*--------------------------------------------------------------
 * Add post thumbnails into admin table
 *------------------------------------------------------------*/
if(!function_exists('add_thumb_column') && function_exists('add_theme_support')) {
  add_theme_support('post-thumbnails', array('post', 'page'));

  function add_thumb_column($cols) {
    $cols['thumbnail'] = __('Thumbnail');
    return $cols;
  }

  function add_thumb_value($column_name, $post_id) {
    $width = 35;
    $height = 35;

    if('thumbnail' == $column_name ) {
      $thumbnail_id = get_post_meta($post_id, '_thumbnail_id', true);

      $attachments = get_children(array('post_parent' => $post_id, 'post_type' => 'attachment', 'post_mime_type' => 'image'));


      if($thumbnail_id)
        $thumb = wp_get_attachment_image($thumbnail_id, array($width, $height), true);
      elseif($attachments) {
        foreach($attachments as $attachment_id => $attachment) {
          $thumb = wp_get_attachment_image($attachment_id, array($width, $height), true);
         }
       }
       if(isset($thumb) && $thumb) {
         echo $thumb;
       } else {
         echo __('None');
       }
    }
  }

  add_filter('manage_posts_columns', 'add_thumb_column');
  add_action('manage_posts_custom_column', 'add_thumb_value', 10, 2);

  add_filter('manage_pages_columns', 'add_thumb_column');
  add_action('manage_pages_custom_column', 'add_thumb_value', 10, 2);
}

?>