<?php
// Register Custom Post Type - LSMC News
register_post_type( 'cpt_lsmcnews',
    array(
    'labels' => array(
        'name'                => _x( 'News', 'News', 'text_domain' ),
        'singular_name'       => _x( 'News', 'News', 'text_domain' ),
        'menu_name'           => __( 'LSMC News', 'text_domain' ),
        'name_admin_bar'      => __( 'News', 'text_domain' ),
        'parent_item_colon'   => __( 'Parent News:', 'text_domain' ),
        'all_items'           => __( 'All News', 'text_domain' ),
        'add_new_item'        => __( 'Add New a News', 'text_domain' ),
        'add_new'             => __( 'Add a News Item', 'text_domain' ),
        'new_item'            => __( 'New News', 'text_domain' ),
        'edit_item'           => __( 'Edit News', 'text_domain' ),
        'update_item'         => __( 'Update News', 'text_domain' ),
        'view_item'           => __( 'View News', 'text_domain' ),
        'search_items'        => __( 'Search News', 'text_domain' ),
        'not_found'           => __( 'No News found', 'text_domain' ),
        'not_found_in_trash'  => __( 'No News found in Trash', 'text_domain' ),
    ),
    'label'               => __( 'LSMC News', 'text_domain' ),
    'description'         => __( 'LSMC News Description', 'text_domain' ),
    'supports'            => array('title','editor','thumbnail','excerpt'),
    'taxonomies'          => array( 'category', 'post_tag' ),
    'hierarchical'        => true,
    'public'              => true,
    'show_ui'             => true,
    'show_in_menu'        => true,
    'menu_position'       => 1,
    'menu_icon'           => 'dashicons-pressthis',
    'show_in_admin_bar'   => true,
    'show_in_nav_menus'   => true,
    'can_export'          => true,
    'has_archive'         => true,
    'exclude_from_search' => false,
    'publicly_queryable'  => true,
    'capability_type'     => 'page',
    'rewrite'             => array( 'slug'=>'lsmc-news' ),
    )
);

// Custom Taxonomies: Categories ///////////////////////////////////
function lsmcnews_categories_taxonomies() {

    // LSMC News Categories
    $labels = array(
        'name'              => 'Categories',
        'singular_name'     => 'Category',
        'search_items'      => 'Search Categories',
        'all_items'         => 'All Categories',
        'parent_item'       => 'Parent Category',
        'parent_item_colon' => 'Parent Category:',
        'edit_item'         => 'Edit Category',
        'update_item'       => 'Update Category',
        'add_new_item'      => 'Add New Category',
        'new_item_name'     => 'New Category',
        'menu_name'         => 'Categories',
    );

    $args = array(
        'hierarchical'      => true,
        'labels'            => $labels,
        'show_ui'           => true,
        'show_admin_column' => true,
        'query_var'         => true,
        'rewrite'           => array( 'slug' => 'lsmc-news-categories' ),
    );

    register_taxonomy( 'lsmc-news-categories', array( 'cpt_lsmcnews' ), $args );
}
add_action( 'init', 'lsmcnews_categories_taxonomies' );

// Custom Taxonomies: Tags ///////////////////////////////////
function lsmcnews_tag_taxonomies() {

    // LSMC News Tags, NOT hierarchical (like tags)
    $labels = array(
        'name' => _x( 'Tags', 'taxonomy general name' ),
        'singular_name' => _x( 'Tag', 'taxonomy singular name' ),
        'search_items' =>  __( 'Search Tags' ),
        'popular_items' => __( 'Popular Tags' ),
        'all_items' => __( 'All Tags' ),
        'parent_item' => null,
        'parent_item_colon' => null,
        'edit_item' => __( 'Edit Tag' ),
        'update_item' => __( 'Update Tag' ),
        'add_new_item' => __( 'Add New Tag' ),
        'new_item_name' => __( 'New Tag Name' ),
        'separate_items_with_commas' => __( 'Separate tags with commas' ),
        'add_or_remove_items' => __( 'Add or remove tags' ),
        'choose_from_most_used' => __( 'Choose from the most used tags' ),
        'menu_name' => __( 'Tags' ),
    );

    register_taxonomy( 'tag', 'cpt_lsmcnews',array(
        'hierarchical' => false,
        'labels' => $labels,
        'show_ui' => true,
        'update_count_callback' => '_update_post_term_count',
        'query_var' => true,
        'rewrite' => array( 'slug' => 'lsmc-news-tags' ),
    ));
}
add_action( 'init', 'lsmcnews_tag_taxonomies', 0 );
?>
